/*
	File:		TrapTools.c

	Contains:	Trap utility functions.

	Version:	Appearance 1.0 SDK

	Copyright:	 1997 by Apple Computer, Inc., all rights reserved.

	File Ownership:

		DRI:				Edward Voas

		Other Contact:		7 of 9, Borg Collective

		Technology:			OS Technologies Group

	Writers:

		(edv)	Ed Voas

	Change History (most recent first):

		 <2>	 9/11/97	edv		Fix header.
		 <1>	 9/11/97	edv		First checked in.
*/

//------------------------------------------------------------------------------
//	Includes
//------------------------------------------------------------------------------

#include <Traps.h>
#include "TrapTools.h"

//------------------------------------------------------------------------------
//	Private prototypes
//------------------------------------------------------------------------------

static int NumToolboxTraps();

//------------------------------------------------------------------------------
//	Implementation
//------------------------------------------------------------------------------

int NumToolboxTraps()
{
	if (NGetTrapAddress(_InitGraf,ToolTrap) == NGetTrapAddress(0xAA6E,ToolTrap))
		return(0x200);
	else
		return(0x400);
}


TrapType GetTrapType(short theTrap)
{
	return((theTrap & 0x0800) ? ToolTrap : OSTrap);
}

Boolean TrapAvailable(short theTrap)
{
	TrapType	tType;
	
	tType = GetTrapType(theTrap);
	if (tType == ToolTrap) {
		theTrap = theTrap & 0x07FF;
		if (theTrap >= NumToolboxTraps())
			theTrap = _Unimplemented;
	}
	return(NGetTrapAddress(theTrap,tType) != NGetTrapAddress(_Unimplemented,ToolTrap));
}
